<?php

    function get_protocol(){
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        return $protocol;
    }

    $actual_link = get_protocol()."$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    $site_url = str_replace("install/", "", $actual_link);
    if($site_url == $actual_link){
        $site_url = str_replace("install", "", $actual_link);
    }
?>

<?php include 'install.php' ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>نصب کننده ژار</title>
    <link href="<?php echo $site_url; ?>static/vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $site_url; ?>static/css/styles.css" rel="stylesheet">
    <link href="<?php echo $site_url; ?>installer/static/install-wizard.css" rel="stylesheet" />
</head>
<body>
    <main class="my-5">
        <div class="container">
            <div id="wizard">
                <h3>
                    <div class="media">
                        <div class="bd-wizard-step-icon"><i class="far fa-handshake"></i></div>
                        <div class="media-body">
                            <div class="bd-wizard-step-title">خوش آمدید</div>
                            <div class="bd-wizard-step-subtitle">گام نخست</div>
                        </div>
                    </div>
                </h3>
                <section>
                    <div class="content-wrapper">
                        <div class="row">
                            <div class="col-md-6">
                            <h4 class="section-heading" style="text-align:right"> به نصب کننده نسخه<?php echo CV; ?> ژار خوش آمدید</h4>
                                <p class="section-description">
                                   بابت استفاده از ژار متشکریم. با قابلیت نصب آسان ژار می توانید اسکریپت را روی سرور خود نصب کنید.
اگر با مشکلی مواجه شدید، لطفا با ما تماس بگیرید.
                                </p>
                                <p>
                                    <a href="https://ernovak.ir" class="btn btn-info" target="_blank">
                                        <i class="fa fa-hands-helping"></i>
                                       کمک نیاز دارم
                                    </a>
                                </p>
                                <div>
                                    <img style="width:100%" src="<?php echo $site_url; ?>installer/img/welcome.svg" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h4 class="section-heading">وضعیت سرور </h4>
                                <p class="section-description">
                                    قبل از نصب اسکریپت، تنظیمات سرور خود را بررسی کنید. اطمینان حاصل کنید که همه ماژول های مورد نیاز نصب شده و الزامات برآورده شده اند.
                                </p>
                                <p class="text-info">وضعیت سرور شما</p>
                                <input type="hidden" id="can-proceed" value="<?php echo $can_proceed ?>"/>
                                <table style="width:100%">
                                    <tr>
                                        <td style="width:20%">پی اچ پی</td>
                                        <td>نسخه <?php echo $currrent_php_version; ?></td>
                                    </tr>
                                    <tr>
                                        <td>آپاچی</td>
                                        <td><?php echo $currrent_apache_version; ?></td>
                                    </tr>
                                </table>
                                <hr>
                                <p class="text-info">برنامه ها و افزودنی ها</p>
                                <table style="width:100%">
                                    <tr>
                                        <td>پی اچ پی <?php echo $required_php_version; ?> یا بالاتر </td>
                                        <td><span class="badge badge-info">مورد نیاز است</span></td>
                                        <td>
                                            <?php if ($required_php_version <= $currrent_php_version){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td> ماژول MySQLi</td>
                                        <td><span class="badge badge-info">مورد نیاز است</span></td>
                                        <td>
                                            <?php if ($is_mysqli_installed){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>GD Library </td>
                                        <td><span class="badge badge-info">مورد نیاز است</span></td>
                                        <td>
                                            <?php if ($is_gd_installed){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Curl PHP Extension</td>
                                        <td><span class="badge badge-info">مورد نیاز است</span></td>
                                        <td>
                                            <?php if ($is_curl_installed){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>MBString PHP Extension	</td>
                                        <td><span class="badge badge-info">مورد نیاز است</span></td>
                                        <td>
                                            <?php if ($is_mbstring_installed){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>FileInfo PHP Extension</td>
                                        <td><span class="badge badge-info">مورد نیاز است</span></td>
                                        <td>
                                            <?php if ($is_fileinfo_installed){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Exif PHP Extension</td>
                                        <td><span class="badge badge-info">مورد نیاز است</span></td>
                                        <td>
                                            <?php if ($is_exif_installed){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>


                                </table>
                                <hr>
                                <p class="text-info mb-0">مجوزهای دایرکتوری</p>
                                <p class="section-description">لطفاً مطمئن شوید که دایرکتوری های زیر قابل نوشتن هستند و مجوزهای لازم تنظیم شده اند.</p>
                                <table style="width:100%">
                                    <tr>
                                        <td>Media Directory <small>(/media)</small></td>
                                        <td> <span class="badge badge-info">0777</span>  <small>مورد نیاز</small></td>
                                        <td> <span class="badge badge-info"><?php echo $media_perm; ?></span> <small>مشاهده شد</small></td>
                                        <td>
                                            <?php if ($is_media_writable){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Config Directory <small>(/config)</small> </td>
                                        <td><span class="badge badge-info">0777</span>  <small>مورد نیاز</small></td>
                                        <td><span class="badge badge-info"><?php echo $config_perm; ?></span> <small>مشاهده شد</small></td>
                                        <td>
                                            <?php if ($is_config_writable){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Language Directory <small>(/lang)</small> </td>
                                        <td><span class="badge badge-info">0777</span>  <small>مورد نیاز</small></td>
                                        <td><span class="badge badge-info"><?php echo $lang_perm; ?></span> <small>مشاهده شد</small></td>
                                        <td>
                                            <?php if ($is_lang_writable){ ?>
                                                <i class="fa fa-check text-success"></i>
                                            <?php } else { ?>
                                                <i title="Not Writable" class="fa fa-times text-danger"></i>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </section>
                <h3>
                    <div class="media">
                        <div class="bd-wizard-step-icon"><i class="fa fa-database"></i></div>
                        <div class="media-body">
                            <div class="bd-wizard-step-title">پیکربندی پایگاه داده</div>
                            <div class="bd-wizard-step-subtitle">گام دوم</div>
                        </div>
                    </div>
                </h3>
                <section>
                    <div class="row">
                        <div class="col-md-12">
                            <h4 class="section-heading">تنظیمات پایگاه داده</h4>
                            <p class="section-description">
                                جزئیات پایگاه داده خود را در اینجا پیکربندی کنید. حتما از یک پایگاه داده خالی استفاده کنید.
                                 قبل از ادامه، از دکمه بررسی اتصال دیتابیس برای بررسی اتصال پایگاه داده استفاده کنید.
                            </p>
                        </div>
                        <div class="col-md-6">
                            <input type="hidden" name="site_url" id="site_url" value="<?php echo $site_url; ?>">
                            <div class="form-group">
                              <label for="database_name">نام دیتابیس</label>
                              <input type="text" id="database_name" class="form-control input-sm" >
                            </div>
                            <div class="form-group">
                              <label for="database_host">میزبان دیتابیس</label>
                              <input type="text" id="database_host" value="localhost" class="form-control input-sm" >
                            </div>
                            <div class="form-group">
                              <label for="database_port">پورت دیتابیس</label>
                              <input type="text" id="database_port" value="3306" class="form-control input-sm">
                            </div>
                        </div>
                        <div class="col-md-6">
                              <div class="form-group">
                                <label for="database_user">نام کاربری دیتابیس</label>
                                <input type="text" id="database_user" value="" class="form-control input-sm">
                              </div>
                              <div class="form-group">
                                <label for="database_password">رمز عبور دیتابیس</label>
                                <input type="text" id="database_password" class="form-control">
                              </div>
                              <button id="test_connection" class="btn btn-primary">بررسی اتصال دیتابیس</button>
                        </div>
                    </div>
                </section>
                <h3>
                    <div class="media">
                        <div class="bd-wizard-step-icon"><i class="fa fa-user-shield"></i></div>
                        <div class="media-body">
                            <div class="bd-wizard-step-title">حساب مدیر </div>
                            <div class="bd-wizard-step-subtitle">گام سوم</div>
                        </div>
                    </div>
                </h3>
                <section>
                    <div class="row">
                        <div class="col-md-12">
                            <h4 class="section-heading">حساب مدیریت</h4>
                            <p class="section-description">
لطفا مشخصات حساب مدیر را وارد کنید. شما می توانید اطلاعات را بعد از ورود به کاربری تغییر دهید

                            </p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                              <label for="first_name">نام</label>
                              <input type="text" id="first_name" value="" class="form-control input-sm">
                            </div>
                            <div class="form-group">
                                <label for="last_name">نام خانوادگی</label>
                                <input type="text" id="last_name" value="" class="form-control input-sm">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="username">نام کاربری</label>
                                <input type="text" id="username" value="" class="form-control input-sm">
                            </div>
                            <div class="form-group">
                                <label for="email">پست الکترونیک</label>
                                <input type="email" id="email" value="" class="form-control input-sm">
                            </div>
                            <div class="form-group">
                                <label for="password">رمز عبور</label>
                                <input type="text" id="password" value="" class="form-control">
                            </div>
						
						</div>
						
					<div class="col-md-6">  
						<div class="form-group">
                                <label for="RTL_USERNAME">نام کاربری راستچین</label>
                                <input type="text" id="RTL_USERNAME" value="" class="form-control">
                            </div>
							 <div class="form-group">
                                <label for="RTL_ORDERID">شماره سفارش راستچین</label>
                                <input type="text" id="RTL_ORDERID" value="" class="form-control">
                            </div>
							</div> 
							<div class="col-md-6">  
							 <div class="form-group">
                                <label for="RTL_DOMAIN">دامنه ثبت شده محصول</label>
                                <input disabled readonly type="text" id="RTL_DOMAIN" value="<?php echo $site_url; ?>" class="form-control">
                            </div>
							 <div class="form-group">
                                <label for="RTL_PRODUCTID">شناسه محصول در راستچین</label>
                                <input type="text" id="RTL_PRODUCTID" value="" class="form-control">
                            </div>
						</div>
					

                    </div>
						<p style="color:red"> در صورت ورود اطلاعات ناصحیح لایسنس، امکان ورود به بخش مدیریت برای شما فراهم نخواهد شد </p>
                </section>
                <h3>
                    <div class="media">
                        <div class="bd-wizard-step-icon"><i class="fa fa-running"></i></div>
                        <div class="media-body">
                            <div class="bd-wizard-step-title">نصب</div>
                            <div class="bd-wizard-step-subtitle">گام چهارم</div>
                        </div>
                    </div>
                </h3>
                <section>
                    <div class="row install-pending">
                        <div class="col-md-6">
                            <img style="width:100%" src="<?php echo $site_url; ?>installer/img/install.svg" />
                        </div>
                        <div class="col-md-6">
                            <h4 class="section-heading">نصب ژار</h4>
                            <p class="section-description">
                                روی دکمه نصب کلیک کنید تا مراحل نصب شروع شود.
                                 برگه یا مرورگر را نبندید. این فرآیند نصب ممکن است چند دقیقه طول بکشد تا کامل شود.
                            </p>
                            <p>
                                <div class="form-group">
                                    <label for="purchase_code">ژار بر روی این آدرس نصب می شود </label>
                                    <input disabled readonly type="text" value="<?php echo $site_url; ?>" class="form-control input-sm">
                                    <small>اگر می‌خواهید  آدرس سایت را تغییر دهید، از نشانی که می‌خواهید ژار نصب شود به نصب‌کننده دسترسی پیدا کنید.</small>
                                </div>
                            </p>
                            <p>
                                <div class="form-group">
                                    <label for="purchase_code text-info" style="display:none">کد خرید</label>
                                    <input type="text" id="purchase_code" value="2210391059600" style="display:none" class="form-control input-sm" disabled>
                                    </div>
                            </p>
                            <p>
                                <button id="install" class="btn btn-primary">نصب</button>
                            </p>
                        </div>
                    </div>
                    <div class="row install-success" style="display:none;">
                        <div class="col-md-6">
                            <img style="width:100%" src="<?php echo $site_url; ?>installer/img/finish.svg" />
                        </div>
                        <div class="col-md-6">
                            <h4 class="section-heading">ژار با موفقیت نصب شد</h4>
                            <p class="section-description">
                                تبریک می گوییم، شما با موفقیت ژار را روی سرور خود نصب کردید.
لطفا روی دکمه زیر کلیک کنید تا وارد شوید و از سامانه ژار خود لذت ببرید.
                            </p>
                            <p>
                                <a href="<?php echo $site_url; ?>" class="btn btn-primary">مشاهده</a>
                            </p>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </main>
    <script src="<?php echo $site_url; ?>static/vendor/jquery/jquery.min.js"></script>
    <script src="<?php echo $site_url; ?>static/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $site_url; ?>static/js/loadingoverlay.min.js" ></script>
    <script src="<?php echo $site_url; ?>installer/static/jquery.steps.min.js" type="text/javascript"></script>
    <script src="<?php echo $site_url; ?>installer/static/install-wizard.js" type="text/javascript"></script>
</body>

</html>
